<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$fitmeal_choices =  array();
$fitmeal_choices['default'] = esc_html__( 'Default', 'fitmeal' );

$fitmeal_color_schemes = fw_get_db_settings_option( 'items' );
if ( !empty($fitmeal_color_schemes) ) {

	foreach ($fitmeal_color_schemes as $v) {

		$fitmeal_choices[$v['slug']] = esc_html( $v['name'] );
	}
}

$fitmeal_theme_config = fitmeal_theme_config();
$fitmeal_sections_list = fitmeal_get_sections();


$options = array(
	'general' => array(
		'title'   => esc_html__( 'Page settings', 'fitmeal' ),
		'type'    => 'box',
		'options' => array(		
			'general-box' => array(
				'title'   => __( 'General Settings', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(

					'margin-layout'    => array(
						'label' => esc_html__( 'Content Margin', 'fitmeal' ),
						'type'    => 'select',
						'desc'   => esc_html__( 'Margins control for content', 'fitmeal' ),
						'choices' => array(
							'default'  => esc_html__( 'Top And Bottom', 'fitmeal' ),
							'top'  => esc_html__( 'Top Only', 'fitmeal' ),
							'bottom'  => esc_html__( 'Bottom Only', 'fitmeal' ),
							'disabled' => esc_html__( 'Margin Removed', 'fitmeal' ),
						),
						'value' => 'default',
					),			
					'topbar-layout'    => array(
						'label' => esc_html__( 'Topbar section', 'fitmeal' ),
						'desc' => esc_html__( 'You can edit it in Sections menu of dashboard.', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array('default' => 'Default') + array('hidden' => 'Hidden') + $fitmeal_sections_list['top_bar'],						
						'value'	=> 'default',
					),						
					'navbar-layout'    => array(
						'label' => esc_html__( 'Navbar', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array( 'default'  	=> esc_html__( 'Default', 'fitmeal' ) ) + $fitmeal_theme_config['navbar'] + array( 'disabled'  	=> esc_html__( 'Hidden', 'fitmeal' ) ),
						'value' => $fitmeal_theme_config['navbar-default'],
					),								
					'header-layout'    => array(
						'label' => esc_html__( 'Page Header', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'default'  => esc_html__( 'Default', 'fitmeal' ),
							'disabled' => esc_html__( 'Hidden', 'fitmeal' ),
						),
						'value' => 'default',
					),						
					'subscribe-layout'    => array(
						'label' => esc_html__( 'Subscribe Block', 'fitmeal' ),
						'type'    => 'select',
						'desc'   => esc_html__( 'Subscribe block before footer. Can be edited from Sections Menu.', 'fitmeal' ),
						'choices' => array(
							'default'  => esc_html__( 'Default', 'fitmeal' ),
							'disabled' => esc_html__( 'Hidden', 'fitmeal' ),
						),
						'value' => 'default',
					),		
					'before-footer-layout'    => array(
						'label' => esc_html__( 'Before Footer', 'fitmeal' ),
						'type'    => 'select',
						'desc'   => esc_html__( 'Before footer sections. Edited in Sections menu.', 'fitmeal' ),
						'choices' => array(
							'default'  => esc_html__( 'Default', 'fitmeal' ),
							'disabled' => esc_html__( 'Hidden', 'fitmeal' ),
						),
						'value' => 'default',
					),	
					'footer-layout'    => array(
						'label' => esc_html__( 'Footer', 'fitmeal' ),
						'type'    => 'select',
						'desc'   => esc_html__( 'Footer block before footer. Edited in Widgets menu.', 'fitmeal' ),
						'choices' => $fitmeal_theme_config['footer'] + array( 'disabled'  	=> esc_html__( 'Hidden', 'fitmeal' ) ),
						'value' => $fitmeal_theme_config['footer-default'],
					),	
					'footer-parallax'    => array(
						'label' => esc_html__( 'Footer Parallax', 'fitmeal' ),
						'type'    => 'select',
						'desc'   => esc_html__( 'Footer block parallax effect.', 'fitmeal' ),
						'choices' => array(
							'default'  => esc_html__( 'Default', 'fitmeal' ),
							'disabled' => esc_html__( 'Disabled', 'fitmeal' ),
						),
						'value' => 'default',
					),																			
					'color-scheme'    => array(
						'label' => esc_html__( 'Color Scheme', 'fitmeal' ),
						'type'    => 'select',
						'choices' => $fitmeal_choices,
						'value' => 'default',
					),		
					'body-bg'    => array(
						'label' => esc_html__( 'Background Scheme', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'default'  => esc_html__( 'White', 'fitmeal' ),
							'black'  => esc_html__( 'Black', 'fitmeal' ),
						),
						'value' => 'default',
					),						
					'background-image'    => array(
						'label' => esc_html__( 'Background Image', 'fitmeal' ),
						'type'  => 'upload',
						'desc'   => esc_html__( 'Will be used to fill whole page', 'fitmeal' ),
					),												
				),											
			),	
			'cpt' => array(
				'title'   => esc_html__( 'Blog / Gallery', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(				
					'sidebar-layout'    => array(
						'label' => esc_html__( 'Blog Sidebar', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'hidden' => esc_html__( 'Hidden', 'fitmeal' ),
							'left'  => esc_html__( 'Sidebar Left', 'fitmeal' ),
							'right'  => esc_html__( 'Sidebar Right', 'fitmeal' ),
						),
						'value' => 'hidden',
					),						
					'blog-layout'    => array(
						'label' => esc_html__( 'Blog Layout', 'fitmeal' ),
						'description'   => esc_html__( 'Used only for blog pages.', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'default'  => esc_html__( 'Default', 'fitmeal' ),
							'classic'  => esc_html__( 'One Column', 'fitmeal' ),
							'two-cols' => esc_html__( 'Two Columns', 'fitmeal' ),
							'three-cols' => esc_html__( 'Three Columns', 'fitmeal' ),
						),
						'value' => 'default',
					),
					'gallery-layout'    => array(
						'label' => esc_html__( 'Gallery Layout', 'fitmeal' ),
						'description'   => esc_html__( 'Used only for gallery pages.', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'default' => esc_html__( 'Default', 'fitmeal' ),
							'col-2' => esc_html__( 'Two Columns', 'fitmeal' ),
							'col-3' => esc_html__( 'Three Columns', 'fitmeal' ),
							'col-4' => esc_html__( 'Four Columns', 'fitmeal' ),
						),
						'value' => 'default',
					),					
				)
			)	
		)
	),
);

unset($options['general']['options']['general-box']['options']['footer-parallax']);
unset($options['general']['options']['general-box']['options']['before-footer-layout']);

