<?php if ( ! defined( 'ABSPATH' ) ) die( 'Forbidden' );
/**
 * Shortcode Slider
 */

// Shortcode fields configuration
if ( !function_exists( 'ltx_vc_slider_full_params' ) ) {

	function ltx_vc_slider_full_params() {

		$fields = array(

			array(
				'type' => 'param_group',
				'param_name' => 'ltx_vc_slider_full_params',
				'heading' => esc_html__( 'Items', 'lt-ext' ),
				"description" => wp_kses_data( __("Add slide items", 'lt-ext') ),
				'value' => urlencode( json_encode( array(
					array(
						'header' => '',
					),
				) ) ),
				'params' => array(
					array(
						"param_name" => "image",
						"heading" => esc_html__("Background image", 'lt-ext'),
						"type" => "attach_image"
					),					
					array(
						'param_name' => 'header',
						'heading' => esc_html__( 'Header', 'lt-ext' ),
						'type' => 'textarea',
						"description" => esc_html__("Use {{ brackets }} to add subheader ", 'lt-ext'),
						'admin_label' => true,
					),
					array(
						'param_name' => 'descr',
						'heading' => esc_html__( 'Description', 'lt-ext' ),
						'type' => 'textarea',
						'admin_label' => false,
					),				
					array(
						'param_name' => 'button',
						'heading' => esc_html__( 'Button Header', 'lt-ext' ),
						'type' => 'textfield',
					),																
					array(
						'param_name' => 'href',
						'heading' => esc_html__( 'Href', 'lt-ext' ),
						'type' => 'textfield',
					),
					array(
						"param_name" => "btn-color",
						"heading" => esc_html__("Background color", 'lt-ext'),
						"std" => "main",
						"value" => array(
							esc_html__('Main', 'lt-ext') 	=> 'main',
							esc_html__('Secondary', 'lt-ext') 	=> 'second',
							esc_html__('White', 'lt-ext') 	=> 'white',
							esc_html__('Black', 'lt-ext') 	=> 'black',
							esc_html__('Gray', 'lt-ext') 	=> 'gray',
							esc_html__('Transparent', 'lt-ext') 	=> 'transparent',
						),
						"type" => "dropdown"
					),					

					array(
						'param_name' => 'header-color',
						'heading' => esc_html__( 'Custom header color', 'lt-ext' ),
						'type' => 'colorpicker',
					),			
					array(
						'param_name' => 'text-color',
						'heading' => esc_html__( 'Custom text color', 'lt-ext' ),
						'type' => 'colorpicker',
					),			
					array(
						'param_name' => 'btn-color-custom',
						'heading' => esc_html__( 'Custom button color', 'lt-ext' ),
						'type' => 'colorpicker',
					),																												
				),
			),	
		);

		return $fields;
	}
}

// Add Wp Shortcode
if ( !function_exists( 'like_sc_slider_full' ) ) {

	function like_sc_slider_full($atts, $content = null) {	

		$atts = like_sc_atts_parse('like_sc_slider_full', $atts, array_merge( array(

			'arrows'			=> 'enabled',
			'ltx_vc_slider_full_params'		=> '',
			'pagination'		=> 'enabled',
			'effect'			=> 'flip',
			'image_status'		=> 'visible',
			'autoplay'		=> 0,
			'background'		=> '',
			'readmore'		=> '',
			'background_status'	=> 'hidden',
			'category_filter'	=> '',

			), array_fill_keys(array_keys(ltx_vc_default_params(true)), null) )
		);

		$atts['items'] = json_decode ( urldecode( $atts['ltx_vc_slider_full_params'] ), true );

		ltx_wp_enqueue('script', 'ltx-fc-slider', 'shortcodes/slider_full/slider-full.js', array('jquery'));
		ltx_wp_enqueue('style', 'ltx-fc-slider', 'shortcodes/slider_full/slider-full.css');


		return like_sc_output('slider_full', $atts, $content);
	}

	if (ltx_vc_inited()) add_shortcode("like_sc_slider_full", "like_sc_slider_full");
}


// Adding shortcode to VC
if (!function_exists('ltx_vc_slider_full_add')) {

	function ltx_vc_slider_full_add() {
		
		vc_map( array(
			"base" => "like_sc_slider_full",
			"name" 	=> esc_html__("Slider Full Screen", 'lt-ext'),
			"description" => esc_html__("Fullscreen slider without autoplay", 'lt-ext'),
			"class" => "like_sc_slider_full",
//			"icon"	=>	ltxGetPluginUrl('/shortcodes/slider_full/swiper_slider.png'),
			"category" => esc_html__('LTX-Themes', 'lt-ext'),
			"params" => array_merge(
				ltx_vc_slider_full_params(),
				ltx_vc_default_params()
			),
		) );
	}

	if (ltx_vc_inited()) add_action('vc_before_init', 'ltx_vc_slider_full_add', 30);
}


